/**
* \file: DevelopersAuthenticator.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: Android Auto
*
* \author: P. Acar / ADIT/SW2 / pacar@de.adit-jv.com
*
* \copyright (c) 2015 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#ifndef AAUTO_DEV_AUTHENTICATOR_H
#define AAUTO_DEV_AUTHENTICATOR_H

#include <string.h>
#include <aauto/GalReceiver.h>
#include <aauto/util/shared_ptr.h>

namespace adit { namespace aauto {

class DevelopersAuthenticator
{
public:
    DevelopersAuthenticator();
    ~DevelopersAuthenticator();

    /**
     * @brief Sets the raw data developers certificates.
     *
     * @param receiver Pointer to the GalReceiver.
     *
     * @return true on success, false on failure
     * */
    bool setCertificates(shared_ptr<GalReceiver> receiver);

    /**
     * @brief Sets the configuration parameters
     *        to keep the interface identical for authentication mechanisms
     *
     * @param inKey Key name.
     *        "keyId" for the key ID
     *        "rootCertificate" for path to the root certificate
     *        "clientCertificate" for path to the client certificate
     *        "privateKey" for path to the private key
     *
     * @param inValue Key value for the associated key name.
     * */
    void setConfigItem(std::string inKey, std::string inValue);

private:

    /**
     * @brief Returns unwrapped root certificate.
     *
     * @return Root certificate as raw data.
     *         Empty string means error.
     * */
    std::string getRootCert();

    /**
     * @brief Returns unwrapped client certificate.
     *
     * @return Client certificate as raw data.
     *         Empty string means error.
     * */
    std::string getClientCert();

    /**
     * @brief Returns unwrapped private key.
     *
     * @return Private key as raw data.
     *         Empty string means error.
     * */
    std::string getPrivateKey();

};

} } /* namespace adit { namespace aauto { */

#endif /* AAUTO_DEV_AUTHENTICATOR_H */

